<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include 'conexao.php';

// 1. Carregar filtros e cursos dinamicamente
$query_cursos = "SELECT DISTINCT curso FROM turmas ORDER BY curso ASC";
$res_cursos = $conn->query($query_cursos);

$lista_todos_cursos = [];
if ($res_cursos) {
    while($c = $res_cursos->fetch_assoc()){
        $lista_todos_cursos[] = $c['curso'];
    }
}

$query_anos = "SELECT DISTINCT ano_letivo FROM matriculas ORDER BY ano_letivo DESC";
$res_anos = $conn->query($query_anos);

$curso_selecionado = $_GET['curso'] ?? '';
$ano_selecionado = $_GET['ano_letivo'] ?? '';
$trimestre_selecionado = (int)($_GET['trimestre'] ?? 1);
$modo_geral = isset($_GET['modo_geral']); 

$cursos_para_processar = $modo_geral ? $lista_todos_cursos : ($curso_selecionado ? [$curso_selecionado] : []);
$dados_completos = [];

if (!empty($cursos_para_processar) && $ano_selecionado) {
    $placeholders = implode(',', array_fill(0, count($cursos_para_processar), '?'));
    
    $sql = "
    SELECT 
        t.curso, t.classe, t.nome AS turma_nome, t.turno,
        SUM(CASE WHEN a.genero = 'Masculino' THEN 1 ELSE 0 END) AS t_m,
        SUM(CASE WHEN a.genero = 'Feminino' THEN 1 ELSE 0 END) AS t_f,
        SUM(CASE WHEN m.tipo_movimentacao = 'Entrada' AND a.genero = 'Masculino' THEN 1 ELSE 0 END) AS in_m,
        SUM(CASE WHEN m.tipo_movimentacao = 'Entrada' AND a.genero = 'Feminino' THEN 1 ELSE 0 END) AS in_f,
        SUM(CASE WHEN m.tipo_movimentacao = 'Saida' AND a.genero = 'Masculino' THEN 1 ELSE 0 END) AS out_m,
        SUM(CASE WHEN m.tipo_movimentacao = 'Saida' AND a.genero = 'Feminino' THEN 1 ELSE 0 END) AS out_f,
        SUM(CASE WHEN a.genero='Masculino' AND EXISTS(SELECT 1 FROM notas n LEFT JOIN avaliacoes_continuas ac ON ac.aluno_id=n.aluno_id AND ac.turma_id=n.turma_id AND ac.trimestre=n.trimestre WHERE n.aluno_id=a.id AND n.turma_id=t.id AND n.trimestre=? AND ((COALESCE(n.npt,0)+COALESCE(ac.mac,0))/2)>=9.5) THEN 1 ELSE 0 END) AS ap_m,
        SUM(CASE WHEN a.genero='Feminino' AND EXISTS(SELECT 1 FROM notas n LEFT JOIN avaliacoes_continuas ac ON ac.aluno_id=n.aluno_id AND ac.turma_id=n.turma_id AND ac.trimestre=n.trimestre WHERE n.aluno_id=a.id AND n.turma_id=t.id AND n.trimestre=? AND ((COALESCE(n.npt,0)+COALESCE(ac.mac,0))/2)>=9.5) THEN 1 ELSE 0 END) AS ap_f,
        SUM(CASE WHEN a.genero='Masculino' AND EXISTS(SELECT 1 FROM notas n WHERE n.aluno_id=a.id AND n.turma_id=t.id AND n.trimestre=? AND n.npt IS NOT NULL) THEN 1 ELSE 0 END) AS av_m,
        SUM(CASE WHEN a.genero='Feminino' AND EXISTS(SELECT 1 FROM notas n WHERE n.aluno_id=a.id AND n.turma_id=t.id AND n.trimestre=? AND n.npt IS NOT NULL) THEN 1 ELSE 0 END) AS av_f,
        SUM(CASE WHEN a.genero='Masculino' AND m.tipo_movimentacao != 'Saida' AND NOT EXISTS(SELECT 1 FROM notas n WHERE n.aluno_id=a.id AND n.turma_id=t.id AND n.trimestre=? AND n.npt IS NOT NULL) THEN 1 ELSE 0 END) AS des_m,
        SUM(CASE WHEN a.genero='Feminino' AND m.tipo_movimentacao != 'Saida' AND NOT EXISTS(SELECT 1 FROM notas n WHERE n.aluno_id=a.id AND n.turma_id=t.id AND n.trimestre=? AND n.npt IS NOT NULL) THEN 1 ELSE 0 END) AS des_f
    FROM matriculas m
    JOIN alunos a ON m.aluno_id = a.id
    JOIN turmas t ON m.turma_id = t.id
    WHERE t.curso IN ($placeholders) AND m.ano_letivo = ?
    GROUP BY t.curso, t.classe, t.id
    ORDER BY t.curso ASC, CAST(t.classe AS UNSIGNED) ASC, t.nome ASC";

    $stmt = $conn->prepare($sql);
    $params_values = array_merge(array_fill(0, 6, $trimestre_selecionado), $cursos_para_processar, [$ano_selecionado]);
    $types = str_repeat('i', 6) . str_repeat('s', count($cursos_para_processar)) . 's';
    $stmt->bind_param($types, ...$params_values);
    $stmt->execute();
    $res = $stmt->get_result();
    while ($row = $res->fetch_assoc()) { $dados_completos[$row['curso']][$row['classe']][] = $row; }
}
?>

<!DOCTYPE html>
<html lang="pt-pt">
<head>
    <meta charset="UTF-8">
    <title>Estatística Geral - CEC 0026</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @media print { .no-print { display: none !important; } body { background: white; padding: 0; } }
        table, th, td { border: 1px solid black !important; border-collapse: collapse; }
        .col-total { background-color: #f3f4f6; font-weight: bold; }
    </style>
</head>
<body class="bg-gray-100 p-4 font-serif">
<div class="max-w-[1500px] mx-auto bg-white p-10 shadow-lg">
    
    <div class="no-print bg-slate-50 p-4 rounded-lg mb-6 flex flex-wrap gap-4 items-end border border-slate-300">
        <form method="GET" class="flex flex-wrap gap-4 items-end">
            <div>
                <label class="block text-[10px] font-bold mb-1 uppercase">Curso:</label>
                <select name="curso" class="border p-2 text-sm rounded w-48">
                    <option value="">-- Selecionar --</option>
                    <?php $res_cursos->data_seek(0); while($c = $res_cursos->fetch_assoc()): ?>
                        <option value="<?= $c['curso'] ?>" <?= $curso_selecionado == $c['curso'] ? 'selected' : '' ?>><?= $c['curso'] ?></option>
                    <?php endwhile; ?>
                </select>
            </div>
            <div>
                <label class="block text-[10px] font-bold mb-1 uppercase">Ano Letivo:</label>
                <select name="ano_letivo" class="border p-2 text-sm rounded" required>
                    <?php $res_anos->data_seek(0); while($a = $res_anos->fetch_assoc()): ?>
                        <option value="<?= $a['ano_letivo'] ?>" <?= $ano_selecionado == $a['ano_letivo'] ? 'selected' : '' ?>><?= $a['ano_letivo'] ?></option>
                    <?php endwhile; ?>
                </select>
            </div>
            <div>
                <label class="block text-[10px] font-bold mb-1 uppercase">Trimestre:</label>
                <select name="trimestre" class="border p-2 text-sm rounded">
                    <?php for($i=1;$i<=3;$i++): ?>
                        <option value="<?= $i ?>" <?= $trimestre_selecionado == $i ? 'selected' : '' ?>><?= $i ?>º Trimestre</option>
                    <?php endfor; ?>
                </select>
            </div>
            <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded font-bold hover:bg-blue-700">GERAR ESTATÍSTICA</button>
            <button type="submit" name="modo_geral" value="1" class="bg-purple-700 text-white px-4 py-2 rounded font-bold hover:bg-purple-800 uppercase">📊 Estatística Geral</button>
        </form>
    </div>

    <div class="text-center mb-8">
        <img src="insignia/insignia.png" alt="Insígnia da República" class="w-16 mx-auto mb-2">
        <h3 class="font-bold text-sm uppercase leading-tight">REPÚBLICA DE ANGOLA</h3>
        <h3 class="font-bold text-sm uppercase leading-tight">MINISTÉRIO DA EDUCAÇÃO</h3>
        <h3 class="font-bold text-sm uppercase leading-tight">MAGISTÉRIO Nº 0038 BLA - 5 DE OUTUBRO - GAMA - CATUMBELA</h3>
       
        
        <div class="mt-4">
            <h1 class="font-black text-lg underline uppercase italic">ESTATÍSTICA DE APROVEITAMENTO ESCOLAR</h1>
            <p class="font-bold text-sm uppercase"><?= $trimestre_selecionado ?>º TRIMESTRE | ANO LECTIVO <?= htmlspecialchars($ano_selecionado) ?></p>
        </div>
    </div>

    <table class="w-full text-[10px] text-center border-black">
        <thead>
            <tr class="bg-slate-200 uppercase font-bold">
                <th rowspan="3" class="w-64 p-2">Estrutura Escolar</th>
                <th colspan="3">Matriculados</th>
                <th colspan="6" class="bg-slate-300">Transferências</th>
                <th colspan="3">Avaliados</th>
                <th colspan="4" class="bg-green-50">Alunos com Aproveitamento</th>
                <th colspan="3">Desistentes</th>
            </tr>
            <tr class="bg-slate-100 text-[8px]">
                <th colspan="3">Início Ciclo</th>
                <th colspan="3">Entradas</th>
                <th colspan="3">Saídas</th>
                <th colspan="3">Total</th>
                <th colspan="3">Total</th>
                <th rowspan="2" class="bg-green-100 font-bold border-l border-black">%</th>
                <th colspan="3">Total</th>
            </tr>
            <tr class="bg-white">
                <th>M</th><th>F</th><th class="col-total">T</th>
                <th>M</th><th>F</th><th class="col-total">T</th>
                <th>M</th><th>F</th><th class="col-total">T</th>
                <th>M</th><th>F</th><th class="col-total">T</th>
                <th>M</th><th>F</th><th class="col-total">T</th>
                <th>M</th><th>F</th><th class="col-total">T</th>
            </tr>
        </thead>
        <tbody>
        <?php 
        $chaves = ['t_m','t_f','in_m','in_f','out_m','out_f','av_m','av_f','ap_m','ap_f','des_m','des_f'];
        $consolidado = array_fill_keys($chaves, 0);

        if(!empty($dados_completos)):
            foreach($dados_completos as $curso_nome => $classes):
                $sub_curso = array_fill_keys($chaves, 0);
                echo "<tr class='bg-gray-100 font-bold'><td colspan='20' class='text-left px-2 py-1 uppercase border-black'>CURSO: $curso_nome</td></tr>";

                foreach($classes as $classe_nome => $turmas):
                    $sub_classe = array_fill_keys($chaves, 0);
                    $classe_limpa = str_replace('ªª', 'ª', $classe_nome . 'ª');

                    foreach($turmas as $d):
                        foreach($chaves as $k) { 
                            $sub_classe[$k] += (int)$d[$k]; 
                            $sub_curso[$k] += (int)$d[$k]; 
                            $consolidado[$k] += (int)$d[$k]; 
                        }
                        $perc = ($d['av_m']+$d['av_f']) > 0 ? round((($d['ap_m']+$d['ap_f'])/($d['av_m']+$d['av_f']))*100, 1) : 0;
        ?>
            <tr>
                <td class="text-left px-2 border italic"><?= $classe_limpa ?> <?= $d['turma_nome'] ?> - <?= $d['turno'] ?></td>
                <td><?= $d['t_m'] ?></td><td><?= $d['t_f'] ?></td><td class="col-total"><?= $d['t_m']+$d['t_f'] ?></td>
                <td><?= $d['in_m'] ?></td><td><?= $d['in_f'] ?></td><td class="col-total"><?= $d['in_m']+$d['in_f'] ?></td>
                <td><?= $d['out_m'] ?></td><td><?= $d['out_f'] ?></td><td class="col-total"><?= $d['out_m']+$d['out_f'] ?></td>
                <td><?= $d['av_m'] ?></td><td><?= $d['av_f'] ?></td><td class="col-total"><?= $d['av_m']+$d['av_f'] ?></td>
                <td><?= $d['ap_m'] ?></td><td><?= $d['ap_f'] ?></td><td class="col-total"><?= $d['ap_m']+$d['ap_f'] ?></td>
                <td class="bg-green-50 font-bold border-l border-black"><?= $perc ?>%</td>
                <td><?= $d['des_m'] ?></td><td><?= $d['des_f'] ?></td><td class="col-total"><?= $d['des_m']+$d['des_f'] ?></td>
            </tr>
            <?php endforeach; 
            $p_classe = ($sub_classe['av_m']+$sub_classe['av_f']) > 0 ? round((($sub_classe['ap_m']+$sub_classe['ap_f'])/($sub_classe['av_m']+$sub_classe['av_f']))*100, 1) : 0;
            ?>
            <tr class="bg-blue-50 font-bold border-black">
                <td class="text-right px-2 uppercase italic text-[9px]">TOTAL <?= $classe_limpa ?>:</td>
                <td><?= $sub_classe['t_m'] ?></td><td><?= $sub_classe['t_f'] ?></td><td class="col-total"><?= $sub_classe['t_m']+$sub_classe['t_f'] ?></td>
                <td><?= $sub_classe['in_m'] ?></td><td><?= $sub_classe['in_f'] ?></td><td class="col-total"><?= $sub_classe['in_m']+$sub_classe['in_f'] ?></td>
                <td><?= $sub_classe['out_m'] ?></td><td><?= $sub_classe['out_f'] ?></td><td class="col-total"><?= $sub_classe['out_m']+$sub_classe['out_f'] ?></td>
                <td><?= $sub_classe['av_m'] ?></td><td><?= $sub_classe['av_f'] ?></td><td class="col-total"><?= $sub_classe['av_m']+$sub_classe['av_f'] ?></td>
                <td><?= $sub_classe['ap_m'] ?></td><td><?= $sub_classe['ap_f'] ?></td><td class="col-total"><?= $sub_classe['ap_m']+$sub_classe['ap_f'] ?></td>
                <td class="bg-green-100 border-l border-black"><?= $p_classe ?>%</td>
                <td><?= $sub_classe['des_m'] ?></td><td><?= $sub_classe['des_f'] ?></td><td class="col-total"><?= $sub_classe['des_m']+$sub_classe['des_f'] ?></td>
            </tr>
            <?php endforeach; 
            $p_curso = ($sub_curso['av_m']+$sub_curso['av_f']) > 0 ? round((($sub_curso['ap_m']+$sub_curso['ap_f'])/($sub_curso['av_m']+$sub_curso['av_f']))*100, 1) : 0;
            ?>
            <tr class="bg-slate-200 font-bold border-black">
                <td class="text-right px-2 uppercase italic">SUBTOTAL DO CURSO:</td>
                <td><?= $sub_curso['t_m'] ?></td><td><?= $sub_curso['t_f'] ?></td><td class="col-total"><?= $sub_curso['t_m']+$sub_curso['t_f'] ?></td>
                <td><?= $sub_curso['in_m'] ?></td><td><?= $sub_curso['in_f'] ?></td><td class="col-total"><?= $sub_curso['in_m']+$sub_curso['in_f'] ?></td>
                <td><?= $sub_curso['out_m'] ?></td><td><?= $sub_curso['out_f'] ?></td><td class="col-total"><?= $sub_curso['out_m']+$sub_curso['out_f'] ?></td>
                <td><?= $sub_curso['av_m'] ?></td><td><?= $sub_curso['av_f'] ?></td><td class="col-total"><?= $sub_curso['av_m']+$sub_curso['av_f'] ?></td>
                <td><?= $sub_curso['ap_m'] ?></td><td><?= $sub_curso['ap_f'] ?></td><td class="col-total"><?= $sub_curso['ap_m']+$sub_curso['ap_f'] ?></td>
                <td class="bg-green-200 border-l border-black"><?= $p_curso ?>%</td>
                <td><?= $sub_curso['des_m'] ?></td><td><?= $sub_curso['des_f'] ?></td><td class="col-total"><?= $sub_curso['des_m']+$sub_curso['des_f'] ?></td>
            </tr>
        <?php endforeach; 

        if ($modo_geral): 
            $p_final = ($consolidado['av_m']+$consolidado['av_f']) > 0 ? round((($consolidado['ap_m']+$consolidado['ap_f'])/($consolidado['av_m']+$consolidado['av_f']))*100, 1) : 0;
        ?>
            <tr class="bg-black text-white font-black uppercase text-[10px] border-black">
                <td class="text-right px-2 border-white italic">RESUMO GERAL DO COMPLEXO (CONSOLIDADO):</td>
                <td><?= $consolidado['t_m'] ?></td><td><?= $consolidado['t_f'] ?></td><td><?= $consolidado['t_m']+$consolidado['t_f'] ?></td>
                <td><?= $consolidado['in_m'] ?></td><td><?= $consolidado['in_f'] ?></td><td><?= $consolidado['in_m']+$consolidado['in_f'] ?></td>
                <td><?= $consolidado['out_m'] ?></td><td><?= $consolidado['out_f'] ?></td><td><?= $consolidado['out_m']+$consolidado['out_f'] ?></td>
                <td><?= $consolidado['av_m'] ?></td><td><?= $consolidado['av_f'] ?></td><td><?= $consolidado['av_m']+$consolidado['av_f'] ?></td>
                <td><?= $consolidado['ap_m'] ?></td><td><?= $consolidado['ap_f'] ?></td><td><?= $consolidado['ap_m']+$consolidado['ap_f'] ?></td>
                <td class="bg-green-700 text-white border-l border-white"><?= $p_final ?>%</td>
                <td><?= $consolidado['des_m'] ?></td><td><?= $consolidado['des_f'] ?></td><td><?= $consolidado['des_m']+$consolidado['des_f'] ?></td>
            </tr>
        <?php endif; 
        else: ?>
            <tr><td colspan="20" class="p-10 text-gray-400 font-bold uppercase text-center border italic">Por favor, selecione os dados para gerar o relatório estatístico.</td></tr>
        <?php endif; ?>
        </tbody>
    </table>

    <div class="mt-16 flex justify-center">
        <div class="text-center w-80">
            <p class="text-xs mb-12">Catumbela, aos <?= date('d') ?> de <?= date('m') ?> de <?= date('Y') ?></p>
            <div class="border-t border-black pt-2 uppercase font-bold text-[10px]">
                O Sub-Director Pedagógico
            </div>
        </div>
    </div>

    <div class="mt-8 text-center no-print">
         <button onclick="window.print()" class="bg-slate-800 text-white px-8 py-3 rounded-full font-bold shadow-xl hover:scale-105 transition-all">
            🖨️ IMPRIMIR ESTATÍSTICA
         </button>
    </div>
</div>
</body>
</html>